/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.test;

import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.ws.api.WSBinding;
import filenet.ws.api.WSBindingInOutBase;
import filenet.ws.api.WSBindingInput;
import filenet.ws.api.WSBindingOperation;
import filenet.ws.api.WSBindingOutput;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSMIMEPart;
import filenet.ws.api.WSMessage;
import filenet.ws.api.WSMessageSchema;
import filenet.ws.api.WSOperation;
import filenet.ws.api.WSParam;
import filenet.ws.api.WSParamLeaf;
import filenet.ws.api.WSParamParent;
import filenet.ws.api.WSPart;
import filenet.ws.api.WSPort;
import filenet.ws.api.WSPortType;
import filenet.ws.api.WSService;
import filenet.ws.api.WSSoapHeader;
import filenet.ws.utils.WSOperationInfoHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.http.HTTPUrlEncoded;
import javax.wsdl.extensions.http.HTTPUrlReplacement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMimeXml;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.symbolTable.BaseType;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionType;
import org.apache.axis.wsdl.symbolTable.DefinedElement;
import org.apache.axis.wsdl.symbolTable.DefinedType;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.PortEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSWSDLTool {
    private WSDefinition m_definition = null;
    private WSMessageSchema m_xmlSchema = null;
    private static final String UNKNOWN = "_UNKNOWN_";

    public void exploreDefinition(String wsdlURL) throws Exception {
        System.out.println("WSDL=" + wsdlURL);
        WSDefinition definition = new WSDefinition(wsdlURL);
        this.exploreDefinition(definition);
        String[] res = this.getSOAPPortTypeNames(definition);
        if (res != null) {
            for (int i = 0; i < res.length; ++i) {
                WSWSDLTool.println("SOAP Bindings = " + res[i], 20);
            }
        }
    }

    public void exploreDefinition(WSDefinition definition) throws Exception {
        WSWSDLTool.printBox("exploreDefinition", 0);
        this.m_definition = definition;
        this.m_xmlSchema = new WSMessageSchema(definition);
        this.exploreMessageSchemas(definition);
        this.getNameSpaces();
        this.explorePortTypes();
        this.exploreServices();
        WSWSDLTool.printBox("Finished exploreDefinition", 0);
    }

    private void getNameSpaces() {
        WSWSDLTool.printBox("getNameSpaces", 10);
        String[] s = null;
        Object temp = null;
        s = this.m_definition.getNameSpaces();
        if (s != null && s.length > 0) {
            String prefix = null;
            for (int i = 0; i < s.length; ++i) {
                if (s[i] == null) continue;
                prefix = this.m_definition.getNamespacePrefix(s[i]);
                if (prefix == null || prefix.length() == 0) {
                    WSWSDLTool.println(s[i], 20);
                    continue;
                }
                WSWSDLTool.println(prefix + "=" + s[i], 20);
            }
        }
        WSWSDLTool.printBox("Finished getNameSpaces", 10);
    }

    private void explorePortTypes() throws Exception {
        WSWSDLTool.printBox("explorePortTypes", 10);
        WSPortType[] portTypes = this.m_definition.getPortTypes();
        if (portTypes != null && portTypes.length > 0) {
            WSPortType portType = null;
            for (int i = 0; i < portTypes.length; ++i) {
                portType = portTypes[i];
                if (portType == null) continue;
                WSWSDLTool.printBox("PortType " + portType.getDisplayName(), 20);
                WSOperation[] operations = portType.getOperations();
                if (operations == null || operations.length <= 0) continue;
                WSOperation operation = null;
                String[] namespaces = null;
                for (int j = 0; j < operations.length; ++j) {
                    operation = operations[j];
                    WSWSDLTool.println("------ Operation " + operation.getDisplayName(), 20);
                    WSWSDLTool.printCRLF();
                    WSWSDLTool.println("Operation.getInMessage", 20);
                    WSMessage inMsg = operation.getInMessage();
                    if (inMsg != null) {
                        // empty if block
                    }
                    WSWSDLTool.println("Operation.getExpressionInMessageTemplate", 20);
                    WSWSDLTool.println(operation.getExpressionInMessageTemplate(), 30);
                    WSWSDLTool.println("Operation.getXMLInMessageTemplate", 20);
                    WSWSDLTool.println(operation.getXMLInMessageTemplate(), 30);
                    namespaces = operation.getInMessageNameSpaces();
                    if (namespaces != null && namespaces.length > 0) {
                        WSWSDLTool.println("Operation.getInMessageNameSpaces", 20);
                        for (int k = 0; k < namespaces.length; ++k) {
                            WSWSDLTool.println(namespaces[k], 30);
                        }
                    }
                    WSWSDLTool.printCRLF();
                    WSWSDLTool.println("Operation.getOutMessage", 20);
                    WSMessage outMsg = operation.getOutMessage();
                    if (outMsg != null) {
                        this.exploreWSMessage(outMsg, 30);
                    }
                    WSWSDLTool.println("Operation.getXMLOutMessageTemplate", 20);
                    WSWSDLTool.println(operation.getXMLOutMessageTemplate(), 30);
                    namespaces = operation.getOutMessageNameSpaces();
                    if (namespaces != null && namespaces.length > 0) {
                        WSWSDLTool.println("Operation.getOutMessageNameSpaces", 20);
                        for (int k = 0; k < namespaces.length; ++k) {
                            WSWSDLTool.println(namespaces[k], 30);
                        }
                    }
                    WSWSDLTool.printCRLF();
                    WSWSDLTool.println("Operation.getFaultTemplates", 20);
                    String[] faults = operation.getFaultTemplates();
                    if (faults != null && faults.length > 0) {
                        for (int k = 0; k < faults.length; ++k) {
                            WSWSDLTool.println(faults[k], 30);
                        }
                    } else {
                        WSWSDLTool.println("NO FAULTS FOUND", 30);
                    }
                    this.exploreOpDocumentation(operation, 20);
                    WSOperationInfoHelper opInfoHelper = WSOperationInfoHelper.getWSOperationInfoHelper(operation);
                    if (opInfoHelper == null) continue;
                    WSWSDLTool.println(opInfoHelper.toString(), 20);
                }
            }
        }
        WSWSDLTool.printBox("Finished explorePortTypes", 10);
    }

    private void exploreNode(Node thisNode, int mySpaces) {
        Element ell;
        if (thisNode == null) {
            return;
        }
        if (thisNode instanceof Text) {
            Text t = (Text)thisNode;
            String data = t.getData();
            if (data != null) {
                WSWSDLTool.println(data, mySpaces);
            }
            return;
        }
        String name = thisNode.getNodeName();
        String ns = thisNode.getNamespaceURI();
        String attrStr = "";
        if (thisNode instanceof Element && (ell = (Element)thisNode).hasAttributes()) {
            StringBuffer buf = new StringBuffer();
            NamedNodeMap attrMap = ell.getAttributes();
            int nAttributes = attrMap.getLength();
            for (int i = 0; i < nAttributes; ++i) {
                Node n = attrMap.item(i);
                buf.append(" ").append(n.getNodeName()).append("=").append(n.getNodeValue());
            }
            attrStr = buf.toString();
        }
        WSWSDLTool.println(name + ", ns=" + ns + attrStr, mySpaces);
        NodeList l = thisNode.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            this.exploreNode(l.item(i), mySpaces + 2);
        }
    }

    private void exploreOpDocumentation(WSOperation op, int mySpaces) {
        if (op == null) {
            return;
        }
        Element docEl = op.getOperation().getDocumentationElement();
        if (docEl == null) {
            WSWSDLTool.println("No Documenation for op.", mySpaces);
            return;
        }
        this.exploreNode(docEl, mySpaces);
    }

    private void exploreWSMessage(WSMessage m, int mySpaces) throws Exception {
        WSWSDLTool.printBox(m.getDisplayName(), mySpaces);
        WSWSDLTool.println("getXMLMessageTemplate:", mySpaces + 10);
        WSWSDLTool.println(m.getXMLMessageTemplate(), mySpaces + 20);
        WSWSDLTool.printCRLF();
        WSWSDLTool.println("getMessageSchema:", mySpaces + 10);
        WSPart[] parts = m.getParts();
        int nParts = parts == null ? 0 : parts.length;
        for (int i = 0; i < nParts; ++i) {
            Part p = parts[i].getPart();
            String pElementString = "NULL";
            try {
                pElementString = p.getElementName().toString();
            }
            catch (Exception e) {
                // empty catch block
            }
            WSWSDLTool.println("WSPart " + Integer.toString(i) + "=" + parts[i].getName() + ", binaryType=" + this.binaryType(m, parts[i].getName()) + ", javax.wsdl.part=" + p.getName() + ", partElement=" + pElementString, mySpaces);
        }
        WSParam[] params = m.getParamList();
        int nParams = params == null ? 0 : params.length;
        for (int i = 0; i < nParams; ++i) {
            this.exploreWSParam(params[i], mySpaces);
        }
    }

    private String getBinaryType(WSParam p) {
        if (p instanceof WSParamLeaf) {
            String typeName = p.getTypeName();
            if (typeName.equals("hexBinary")) {
                return typeName;
            }
            if (typeName.startsWith("base64")) {
                return "base64Binary";
            }
            return UNKNOWN;
        }
        if (p instanceof WSParamParent) {
            WSParamParent pp = (WSParamParent)p;
            WSParam[] params = pp.getChildren();
            int nParams = params == null ? 0 : params.length;
            for (int i = 0; i < nParams; ++i) {
                String res = this.getBinaryType(params[i]);
                if (!res.equals("hexBinary") && !res.equals("base64Binary")) continue;
                return res;
            }
        }
        return UNKNOWN;
    }

    private String binaryType(WSMessage m, String partName) {
        WSParam[] params = m.getParamList();
        int nParams = params == null ? 0 : params.length;
        for (int i = 0; i < nParams; ++i) {
            String pName = params[i].getName();
            if (!pName.equals(partName)) continue;
            return this.getBinaryType(params[i]);
        }
        return UNKNOWN;
    }

    private void exploreWSParam(WSParam param, int mySpaces) {
        WSWSDLTool.println("WSParam: " + param.getName() + ", type=" + param.getTypeName(), mySpaces);
        if (param instanceof WSParamParent) {
            WSParamParent pp = (WSParamParent)param;
            WSParam[] params = pp.getChildren();
            int nParams = params == null ? 0 : params.length;
            for (int i = 0; i < nParams; ++i) {
                this.exploreWSParam(params[i], mySpaces + 2);
            }
        }
    }

    private void exploreMessageSchemas(WSDefinition definition) {
        try {
            if (definition == null) {
                return;
            }
            WSWSDLTool.printBox("exploreMessageSchemas", 10);
            Map messageMap = definition.getDefinition().getMessages();
            Set keys = messageMap.keySet();
            Iterator it = keys.iterator();
            Object obj = null;
            WSWSDLTool.println("Message names are:", 10);
            while (it.hasNext()) {
                obj = it.next();
                if (obj != null) {
                    WSWSDLTool.println(obj.toString(), 20);
                }
                WSMessage m = definition.getMessage((QName)obj);
                this.exploreWSMessage(m, 20);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        WSWSDLTool.printBox("finished exploreMessageSchemas", 10);
    }

    private void exploreServices() throws Exception {
        WSWSDLTool.printBox("exploreServices", 10);
        WSService[] services = this.m_definition.getServices();
        if (services != null && services.length > 0) {
            for (int i = 0; i < services.length; ++i) {
                if (services[i] == null) continue;
                WSWSDLTool.printBox("Service: " + services[i].getDisplayName(), 10);
                WSPort[] ports = services[i].getPorts();
                if (ports == null || ports.length <= 0) continue;
                for (int j = 0; j < ports.length; ++j) {
                    if (ports[j] == null) continue;
                    String s = ports[j].getDisplayName();
                    WSWSDLTool.printBox("Port: " + s, 20);
                    WSBinding binding = ports[j].getBinding();
                    this.exploreBinding(binding, s, 30);
                }
            }
        } else {
            WSWSDLTool.printBox("No Services Found, using Definitions.getBindings", 20);
            WSBinding[] bindings = this.m_definition.getBindings();
            if (bindings != null && bindings.length > 0) {
                for (int i = 0; i < bindings.length; ++i) {
                    this.exploreBinding(bindings[i], "Definition", 20);
                }
            }
        }
        WSWSDLTool.printBox("Finished exploreServices", 10);
    }

    private static void exploreSOAPHeaders(WSSoapHeader[] soapHeaders, String prefix, int bSpaces) throws Exception {
        if (soapHeaders != null && soapHeaders.length > 0) {
            for (int kk = 0; kk < soapHeaders.length; ++kk) {
                String ss = prefix + "part=" + soapHeaders[kk].getPart() + ", Template=" + soapHeaders[kk].getTemplate();
                WSWSDLTool.println(ss, bSpaces + 10);
                String[] namespaces = soapHeaders[kk].getMessageNamespaces();
                if (namespaces == null) continue;
                WSWSDLTool.println(prefix + " namespaces = ", bSpaces + 10);
                for (int idx = 0; idx < namespaces.length; ++idx) {
                    WSWSDLTool.println(namespaces[idx], bSpaces + 20);
                }
            }
        }
    }

    private static void exploreWSBindingInOutBase(WSBindingInOutBase binding, String prefix, int bSpaces) {
        if (binding != null) {
            WSMIMEPart[] mimeParts;
            WSWSDLTool.println("Binding namespace=" + binding.getSoapBodyNamespace(), bSpaces);
            Object[] mimeElements = binding.getMimeElements();
            if (mimeElements != null && mimeElements.length > 0) {
                WSWSDLTool.printCRLF();
                WSWSDLTool.println("BindingOperation." + prefix + ".MIME elements", bSpaces);
                for (int kk = 0; kk < mimeElements.length; ++kk) {
                    if (mimeElements[kk] == null) continue;
                    WSWSDLTool.println("[" + kk + "]=" + mimeElements[kk], bSpaces + 10);
                }
            }
            if ((mimeParts = binding.getMimeParts()) != null && mimeParts.length > 0) {
                WSWSDLTool.println("BindingOperation." + prefix + ".MIME Parts", bSpaces);
                for (int kk = 0; kk < mimeParts.length; ++kk) {
                    WSWSDLTool.exploreMIMEPart(mimeParts[kk], kk, bSpaces + 10);
                }
            }
            String[] encodingStyles = binding.getSoapBodyEncodingStyles();
            String[] parts = binding.getSoapBodyParts();
        }
    }

    private static void exploreMIMEPart(WSMIMEPart part, int index, int bSpaces) {
        WSWSDLTool.println("[" + index + " String version]=" + part.toString(), bSpaces);
        MIMEPart pImpl = part.getMIMEPart();
        List l = pImpl.getExtensibilityElements();
        for (Object o : l) {
            if (o instanceof SOAPBody) {
                WSWSDLTool.println("It's a SOAPBOdy", bSpaces + 2);
                continue;
            }
            if (!(o instanceof MIMEContent)) continue;
            MIMEContent c = (MIMEContent)o;
            WSWSDLTool.println("part=" + c.getPart(), bSpaces + 2);
        }
    }

    private void exploreBinding(WSBinding binding, String portName, int mySpaces) throws Exception {
        if (binding != null) {
            WSBindingOperation[] bindingOperations = binding.getBindingOperations();
            String bName = binding.getDisplayName();
            WSWSDLTool.printCRLF();
            WSWSDLTool.println("Binding: " + bName + ", # ops=" + (bindingOperations == null ? "0" : Integer.toString(bindingOperations.length)) + ", SOAP Binding = " + (binding.getSoapBinding() != null ? "YES" : "NO"), mySpaces);
            if (bindingOperations != null && bindingOperations.length > 0) {
                int bSpaces = mySpaces + 10;
                for (int k = 0; k < bindingOperations.length; ++k) {
                    String result;
                    if (bindingOperations[k] == null) continue;
                    String s = bindingOperations[k].getDisplayName() + " (" + portName + "." + bName + ")";
                    WSWSDLTool.printBox("Binding operation: " + s, bSpaces);
                    if (bindingOperations[k].isSoapBinding()) {
                        WSWSDLTool.println("SoapBinding", bSpaces + 10);
                        WSWSDLTool.println("SoapStyle: = " + bindingOperations[k].getSoapStyle(), bSpaces + 10);
                        WSWSDLTool.println("SoapAction: = " + bindingOperations[k].getSoapAction(), bSpaces + 10);
                    }
                    WSWSDLTool.println("BindingOperation.getInParamTemplate", bSpaces);
                    WSWSDLTool.println(bindingOperations[k].getInParamTemplate(), bSpaces + 10);
                    String inXMLTemplate = bindingOperations[k].getXMLInParamTemplate();
                    if (inXMLTemplate != null && (result = bindingOperations[k].addedBindingInfoToInParam(inXMLTemplate)).compareTo(inXMLTemplate) != 0) {
                        WSWSDLTool.printCRLF();
                        WSWSDLTool.println("BindingOperation.addedBindingInfoToInParam(getXMLInParamTemplate)", bSpaces);
                        WSWSDLTool.println(result, bSpaces + 10);
                    }
                    WSWSDLTool.printCRLF();
                    WSWSDLTool.println("BindingOperation.getSOAPInHeaders", bSpaces);
                    WSSoapHeader[] soapInHeaders = bindingOperations[k].getSoapInHeaders();
                    WSWSDLTool.exploreSOAPHeaders(soapInHeaders, "In Headers ", bSpaces);
                    WSBindingInput bindingInput = bindingOperations[k].getBindingInput();
                    WSWSDLTool.exploreWSBindingInOutBase(bindingInput, "BindingInput", bSpaces);
                    WSWSDLTool.printCRLF();
                    WSWSDLTool.println("BindingOperation.getOutParamTemplate", bSpaces);
                    WSWSDLTool.println(bindingOperations[k].getOutParamTemplate(), bSpaces + 10);
                    WSWSDLTool.printCRLF();
                    WSWSDLTool.println("BindingOperation.getSOAPOutHeaders", bSpaces);
                    WSSoapHeader[] soapOutHeaders = bindingOperations[k].getSoapOutHeaders();
                    WSWSDLTool.exploreSOAPHeaders(soapOutHeaders, "Out Headers ", bSpaces);
                    WSBindingOutput bindingOutput = bindingOperations[k].getBindingOutput();
                    WSWSDLTool.exploreWSBindingInOutBase(bindingOutput, "BindingOutput", bSpaces);
                    WSWSDLTool.printCRLF();
                    String[] sss = bindingOperations[k].getFaultTemplates();
                    if (sss != null) {
                        WSWSDLTool.println("Faults (getFaultTemplates)", bSpaces);
                        for (int index = 0; index < sss.length; ++index) {
                            WSWSDLTool.println(sss[index], bSpaces + 10);
                        }
                    }
                    WSWSDLTool.printBox("Finished Binding operation: " + s, bSpaces);
                }
            }
        }
    }

    private void exploreExtensibilityElements(List l, int spaces) {
        if (l != null && l.size() > 0) {
            Object obj = null;
            for (int i = 0; i < l.size(); ++i) {
                SOAPAddress e;
                MIMEContent m;
                obj = l.get(i);
                if (obj == null) continue;
                WSWSDLTool.println(obj.toString(), spaces);
                ++spaces;
                if (obj instanceof SOAPHeader) {
                    SOAPHeader soapHeader = (SOAPHeader)obj;
                    Message msg = this.m_definition.getMessage(soapHeader.getMessage()).getMessage();
                    WSWSDLTool.println("SOAPHeader: " + soapHeader.toString(), spaces);
                } else if (obj instanceof MIMEContent) {
                    m = (MIMEContent)obj;
                    WSWSDLTool.println("MIMEContent: " + m.toString(), spaces);
                } else if (obj instanceof MIMEMimeXml) {
                    m = (MIMEMimeXml)obj;
                    WSWSDLTool.println("MIMEMimeXml: " + m.toString(), spaces);
                } else if (obj instanceof SOAPAddress) {
                    e = (SOAPAddress)obj;
                    WSWSDLTool.println("SOAPAddress: " + e.toString(), spaces);
                } else if (obj instanceof SOAPBinding) {
                    e = (SOAPBinding)obj;
                    WSWSDLTool.println("SOAPBinding: " + e.toString(), spaces);
                } else if (obj instanceof SOAPBody) {
                    e = (SOAPBody)obj;
                    WSWSDLTool.println("SOAPBody: " + e.toString(), spaces);
                } else if (obj instanceof SOAPFault) {
                    e = (SOAPFault)obj;
                    WSWSDLTool.println("SOAPFault: " + e.toString(), spaces);
                } else if (obj instanceof SOAPHeaderFault) {
                    e = (SOAPHeaderFault)obj;
                    WSWSDLTool.println("SOAPHeaderFault: " + e.toString(), spaces);
                } else if (obj instanceof SOAPOperation) {
                    e = (SOAPOperation)obj;
                    WSWSDLTool.println("SOAPOperation: " + e.toString(), spaces);
                } else if (obj instanceof HTTPAddress) {
                    e = (HTTPAddress)obj;
                    WSWSDLTool.println("HTTPAddress: " + e.toString(), spaces);
                } else if (obj instanceof HTTPBinding) {
                    e = (HTTPBinding)obj;
                    WSWSDLTool.println("HTTPBinding: " + e.toString(), spaces);
                } else if (obj instanceof HTTPUrlEncoded) {
                    e = (HTTPUrlEncoded)obj;
                    WSWSDLTool.println("HTTPUrlEncoded: " + e.toString(), spaces);
                } else if (obj instanceof HTTPUrlReplacement) {
                    e = (HTTPUrlReplacement)obj;
                    WSWSDLTool.println("HTTPUrlReplacement: " + e.toString(), spaces);
                } else if (obj instanceof MIMEMultipartRelated) {
                    e = (MIMEMultipartRelated)obj;
                    WSWSDLTool.println("MIMEMultipartRelated: " + e.toString(), spaces);
                } else if (obj instanceof MIMEPart) {
                    e = (MIMEPart)obj;
                    WSWSDLTool.println("MIMEPart: " + e.toString(), spaces);
                } else if (obj instanceof HTTPUrlEncoded) {
                    e = (HTTPUrlEncoded)obj;
                    WSWSDLTool.println("HTTPUrlEncoded: " + e.toString(), spaces);
                } else if (obj instanceof UnknownExtensibilityElement) {
                    e = (UnknownExtensibilityElement)obj;
                    WSWSDLTool.println("UnknownExtensibilityElement: " + e.toString(), spaces);
                } else {
                    WSWSDLTool.println("Unknow extensibility element type", spaces);
                }
                --spaces;
            }
        }
    }

    private String getIndentationString(int level) {
        String s = new String();
        for (int i = 0; i < level; ++i) {
            s = s + "  ";
        }
        return s;
    }

    private static void println(String s, int spaces) {
        for (int i = 0; i < spaces; ++i) {
            System.out.print(" ");
        }
        System.out.println(s);
    }

    private static String makeLine(int n) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            buf.append("-");
        }
        return buf.toString();
    }

    private static void printCRLF() {
        System.out.println();
    }

    private static void printBox(String s, int spaces) {
        if (s == null || s.trim().length() == 0) {
            return;
        }
        String line = WSWSDLTool.makeLine(s.length());
        WSWSDLTool.println(line, spaces);
        WSWSDLTool.println(s, spaces);
        WSWSDLTool.println(line, spaces);
    }

    private static void print(String s, int spaces) {
        for (int i = 0; i < spaces; ++i) {
            System.out.print(" ");
        }
        System.out.print(s);
    }

    public static void main(String[] args) throws Exception {
        VWCommandLineArgs c = new VWCommandLineArgs(args);
        if (c.isPresent("h") || c.isPresent("?") || c.isPresent("H")) {
            System.out.println("WSWSDLTool [/url=WSDLURL] [/wf2wsdl]");
            System.exit(0);
        }
        if (c.isPresent("inputfile")) {
            String inputFile = c.getParameter("inputfile");
            c = new VWCommandLineArgs(inputFile, false);
        }
        try {
            String URL2 = c.getParameter("url", null);
            System.out.println("Exploring " + URL2);
            WSWSDLTool parser = new WSWSDLTool();
            if (URL2 != null) {
                parser.exploreDefinition(URL2);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    public SymTabEntry getSymTabEntry(QName qname, Class cls) {
        HashMap map = this.m_definition.getParser().getSymbolTable().getHashMap();
        for (Map.Entry entry : map.entrySet()) {
            QName key = (QName)entry.getKey();
            Vector v = (Vector)entry.getValue();
            if (qname != null && !qname.equals(qname)) continue;
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)v.elementAt(i);
                if (!cls.isInstance(symTabEntry)) continue;
                return symTabEntry;
            }
        }
        return null;
    }

    public Port selectPort(Map ports, String portName) throws Exception {
        for (String name : ports.keySet()) {
            if (portName == null || portName.length() == 0) {
                Port port = (Port)ports.get(name);
                List list = port.getExtensibilityElements();
                for (int i = 0; list != null && i < list.size(); ++i) {
                    Object obj = list.get(i);
                    if (!(obj instanceof SOAPAddress)) continue;
                    return port;
                }
                continue;
            }
            if (name == null || !name.equals(portName)) continue;
            return (Port)ports.get(name);
        }
        return null;
    }

    public void explore() {
        int spaces = 0;
        Parser wsdlParser = this.m_definition.getParser();
        SymbolTable symTable = wsdlParser.getSymbolTable();
        HashMap map = wsdlParser.getSymbolTable().getHashMap();
        Iterator iterator = map.entrySet().iterator();
        ++spaces;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            QName key = (QName)entry.getKey();
            Vector v = (Vector)entry.getValue();
            System.out.println();
            System.out.println("**");
            System.out.println(entry.toString());
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)v.elementAt(i);
                if (symTabEntry == null) continue;
                if (symTabEntry instanceof MessageEntry) {
                    System.out.println("* Message Entry:");
                } else if (symTabEntry instanceof BindingEntry) {
                    System.out.println("* Binding Entry:");
                } else if (symTabEntry instanceof ServiceEntry) {
                    System.out.println("* Service Entry:");
                } else if (symTabEntry instanceof DefinedType) {
                    System.out.println("* DefinedType:");
                } else if (symTabEntry instanceof DefinedElement) {
                    System.out.println("* DefinedElement:");
                } else if (symTabEntry instanceof BaseType) {
                    System.out.println("* BaseType:");
                } else if (symTabEntry instanceof PortTypeEntry) {
                    System.out.println("* PortTypeEntry:");
                } else if (symTabEntry instanceof CollectionType) {
                    System.out.println("* CollectionType:");
                } else if (symTabEntry instanceof PortTypeEntry) {
                    System.out.println("* PortTypeEntry:");
                } else if (symTabEntry instanceof PortEntry) {
                    System.out.println("* PortEntry:");
                } else {
                    System.out.println("*? " + symTabEntry.getClass().toString());
                }
                System.out.println(symTabEntry.toString());
            }
        }
        --spaces;
    }

    private String[] getSOAPPortTypeNames(WSDefinition wsDef) {
        WSPortType[] wsPortTypes = wsDef.getPortTypes();
        if (wsPortTypes == null || wsPortTypes.length == 0) {
            return null;
        }
        Vector<String> soapPortTypes = new Vector<String>(1);
        for (int i = 0; i < wsPortTypes.length; ++i) {
            WSBinding wsBinding;
            String portTypeName = wsPortTypes[i].getName();
            WSPort wsPort = wsDef.getDefaultPort(portTypeName);
            if (wsPort == null || (wsBinding = wsPort.getBinding()) == null || wsBinding.getSoapBinding() == null) continue;
            soapPortTypes.add(portTypeName);
        }
        return soapPortTypes.toArray(new String[0]);
    }
}

